/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jface.text.IDocument;
import org2.eclipse.php.internal.core.PHPVersion;

public class PHPVersionDocumentManager {
    private static PHPVersionDocumentManager instance;
    private Map<IDocument, PHPVersion> map = new WeakHashMap<IDocument, PHPVersion>();
    private Map<IDocument, Integer> documentsCount = new WeakHashMap<IDocument, Integer>();

    private PHPVersionDocumentManager() {
    }

    private static PHPVersionDocumentManager getInstance() {
        if (instance == null) {
            instance = new PHPVersionDocumentManager();
        }
        return instance;
    }

    public static PHPVersion getPHPVersion(IDocument document) {
        return PHPVersionDocumentManager.getInstance().map.get(document);
    }

    public static void updateVersion(IDocument document, PHPVersion phpVersion) {
        PHPVersionDocumentManager manager = PHPVersionDocumentManager.getInstance();
        manager.map.put(document, phpVersion);
    }

    public static void increaseDocumentCount(IDocument document) {
        PHPVersionDocumentManager manager = PHPVersionDocumentManager.getInstance();
        Integer count = manager.documentsCount.get(document);
        if (count == null) {
            manager.documentsCount.put(document, 1);
        } else {
            manager.documentsCount.put(document, count + 1);
        }
    }

    public static void decreaseDocumentCount(IDocument document) {
        PHPVersionDocumentManager manager = PHPVersionDocumentManager.getInstance();
        Integer count = manager.documentsCount.get(document);
        if (count == null || count == 1) {
            manager.map.remove(document);
        } else {
            manager.documentsCount.put(document, count - 1);
        }
    }
}

